% param_transform.m
% 
% mapping and inverse mapping of parameter vector on restricted intervals
%   to real numbers
% 
% Estimating Macroeconomic Models of Financial Crises: An Endogenous Regime-Switching Approach*
%   Gianluca Benigno, Andrew Foerster, Christopher Otrok, Alessandro Rebucci
% 
% Updated July 2024
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %
function [newtheta] = param_transform(oldtheta,GLOBALS,option)
% option = 1 takes restricted vector to unrestricted vector
% option = -1 inverse of option 1

newtheta = NaN(size(oldtheta));
% transform the parameter vector -- positive parameters
inds = [GLOBALS.parm_ind.iiota;
        GLOBALS.parm_ind.rbar;
        GLOBALS.parm_ind.ppsir;
        GLOBALS.parm_ind.ssigmaa;
        GLOBALS.parm_ind.ssigmaz;
        GLOBALS.parm_ind.ssigmap;
        GLOBALS.parm_ind.ssigmar;
        GLOBALS.parm_ind.ssigmae;
        GLOBALS.parm_ind.ssigmad;
        ];
if option == -1    
    newtheta(inds) = exp(oldtheta(inds));
elseif option == 1
    newtheta(inds) = log(oldtheta(inds));
end

% transform the parameter vector -- unit interval parameters
inds = [GLOBALS.parm_ind.pphi;
%        GLOBALS.parm_ind.kkappa;
        GLOBALS.parm_ind.rrhoa;
        GLOBALS.parm_ind.rrhoz;
        GLOBALS.parm_ind.rrhop;
        GLOBALS.parm_ind.rrhor;
        GLOBALS.parm_ind.rrhoe;
        GLOBALS.parm_ind.rrhod;        
%        GLOBALS.parm_ind.p01;
%        GLOBALS.parm_ind.p10;        
%         GLOBALS.parm_ind.psigma_ll;
%         GLOBALS.parm_ind.psigma_hh
  ];
if option == -1
    newtheta(inds) = exp(oldtheta(inds))./(1+exp(oldtheta(inds)));
elseif option == 1
    newtheta(inds) = log(oldtheta(inds)./(1-oldtheta(inds)));
end
        
% transform the parameter vector -- unrestricted parameters
inds = [%GLOBALS.parm_ind.loggamma01;
        %GLOBALS.parm_ind.loggamma11
        GLOBALS.parm_ind.bbar
        ];
if option == -1
    newtheta(inds) = oldtheta(inds);
elseif option == 1
    newtheta(inds) = oldtheta(inds);
end

end

